CREATE TABLE report_printermapping --http://redmine.prodat-sql.de/issues/7020
 (rprntm_id              serial PRIMARY KEY,
  rprntm_name            varchar(30),
  rprntm_printer         varchar(500)
 );
 CREATE UNIQUE INDEX rprntm_name_index ON report_printermapping (lower(rprntm_name));

-- [SYNCRO-TABLE] Reports
CREATE TABLE reports
 (r_id                  serial PRIMARY KEY,                                  -- [SYNCRO:NotThisFields]
  r_modulname           varchar(50) NOT NULL,                                --     (wenn ReportLink: rl_modulname)
  r_grouptxt            integer,
  r_descr               integer,                                             --     TextNummer (wenn ReportLink: rl_customTxtNo)
  r_detail              varchar(75),                                         --     (wenn ReportLink: rl_customDetail)
  r_pos                 integer,                                             --     (wenn ReportLink: rl_pos)
  r_ident               varchar(50),
  r_kunde               varchar(50),                                         -- [SYNCRO:Kunde]   [SYNCRO ALT: 'DELETED' see r_deleted]
  r_minver              varchar(11),                                         -- [SYNCRO:Version]
  r_deleted             boolean DEFAULT FALSE,                                  -- [SYNCRO:Deleted] [SYNCRO ALT: r_kunde='DELETED']

  r_inheritfrom         timestamp(0),                                        --     Abgeleitet von Report mit Stamp#
  r_reportgen           varchar(5) DEFAULT 'FR',                             --     Reportgenerator: FR=FastReport LL=List&Label GR=GridReport BMP=PixelReport ESL=Preisschild
  r_reportparameter     text,                                                --     (wenn ReportLink: rl_customParams)
  r_dokutype            varchar(30) REFERENCES dokutypes ON UPDATE CASCADE,
  r_blob                LO,                                                  -- [SYNCRO:TranslateToLocal]
  r_sql                 text,                                                --     (wenn ReportLink: rl_customSql)
  r_beforescript        text,
  r_wherertf            integer REFERENCES runtimeforms ON UPDATE CASCADE,
  r_afterrtf            integer REFERENCES runtimeforms ON UPDATE CASCADE,
  r_afterscript         text,

  r_visible             boolean DEFAULT TRUE,                                -- [SYNCRO:NotThisFields]
  r_shorthlptxtnr       integer,
  r_hlpcontxt           varchar,

  r_changetext          text,
  r_stamp               timestamp(0) UNIQUE NOT NULL DEFAULT currenttime(),  -- [SYNCRO:SyncID]
  r_modified            timestamp(0) DEFAULT currenttime(),                  -- [SYNCRO:Modified]        wenn Tabelle reports, report_datasets oder report_afterrep bearbeitet
  r_localmodified       boolean DEFAULT FALSE                                   -- [SYNCRO:NotThisFields]   True, wenn (lokal) bearbeitet
 );


 CREATE UNIQUE INDEX reports__r_ident__uq ON reports(r_modulname, r_ident) WHERE r_ident IS NOT null;


 --
  CREATE OR REPLACE RULE reports_delete AS     -- DELETE rule
        ON DELETE TO reports WHERE current_user<>'syncro'
        DO INSTEAD
        UPDATE reports SET r_deleted=TRUE WHERE r_id=old.r_id;


  CREATE OR REPLACE FUNCTION reports_modified() RETURNS TRIGGER AS $$
    BEGIN
     IF NOT (current_user='syncro') then
            IF old.r_visible IS DISTINCT FROM new.r_visible THEN --nur Sichtbarkeit geschalten (über Popup, daher ist sicher das nur diese eine Spalte im Record umgeschrieben wird)
            ELSE
                    new.r_modified:=currenttime();
                    new.r_localmodified:=TRUE;
            END IF;
     ELSE
            new.r_localmodified:=FALSE;--local aktualisieren durch Syncro.
     END IF;
     RETURN new;
    END $$ LANGUAGE plpgsql;

    CREATE TRIGGER reports_modified
     BEFORE UPDATE
     ON reports
     FOR EACH ROW
     EXECUTE PROCEDURE reports_modified();

-- [SYNCRO-TABLE] Report-Datasets
CREATE TABLE report_datasets
 (rds_id                serial        PRIMARY KEY,
  rds_r_id              integer       NOT NULL REFERENCES reports ON DELETE CASCADE,  -- [SYNCRO:TranslateToLocal]
  rds_r_stamp           timestamp(0)  REFERENCES reports(r_stamp) ON UPDATE CASCADE ON DELETE CASCADE,
  rds_pos               integer,
  rds_name              varchar(10),
  rds_master            varchar(10),
  rds_descr             varchar(50),
  rds_sql               text,
  rds_deact             boolean       DEFAULT TRUE,
  rds_linkfield         varchar,
  rds_masterfield       varchar
 );
---
CREATE OR REPLACE FUNCTION report_datasets__rds_r_stamp__b_iu() RETURNS TRIGGER
  AS $$
  BEGIN
    IF new.rds_r_stamp IS null THEN -- Anlage aus Delphi
       new.rds_r_stamp := r_stamp FROM reports WHERE r_id = new.rds_r_id;
    END IF;
    -- lokale id übersetzen
    new.rds_r_id := r_id FROM reports WHERE r_stamp = new.rds_r_stamp;
    RETURN new;
  END $$ LANGUAGE plpgsql;

CREATE TRIGGER report_datasets__rds_r_stamp__b_iu
  BEFORE INSERT OR UPDATE
  ON report_datasets
  FOR EACH ROW
  EXECUTE PROCEDURE report_datasets__rds_r_stamp__b_iu();

 --
  CREATE OR REPLACE FUNCTION report_datasets_modified() RETURNS TRIGGER AS $$
    BEGIN
     IF NOT (current_user='syncro') then
            UPDATE reports SET r_modified=currenttime() WHERE r_id=new.rds_r_id;
     END IF;
     RETURN new;
    END $$ LANGUAGE plpgsql;

   CREATE TRIGGER report_datasets_modified
    BEFORE INSERT OR UPDATE
    ON report_datasets
    FOR EACH ROW

    EXECUTE PROCEDURE report_datasets_modified();

-- [SYNCRO-TABLE] Report-Links
CREATE TABLE report_links
 (rl_id                 serial        PRIMARY KEY,                         -- [SYNCRO:NotThisFields]
  rl_stamp              timestamp(0)  UNIQUE DEFAULT currenttime(),  -- [SYNCRO:SyncID]
  rl_modified           timestamp(0),                               -- [SYNCRO:Modified]
  rl_r_stamp            timestamp(0)  NOT NULL REFERENCES reports(r_stamp) ON UPDATE CASCADE ON DELETE CASCADE, -- hängt an diesem Report
  rl_modulname          varchar(75)   NOT NULL,
  rl_pos                integer,
  rl_ident              varchar(50),
  rl_customTxtNo        integer,
  rl_customDetail       varchar(100),
  rl_customSql          text,
  rl_customParams       text,
  rl_customWhereRtf     integer       REFERENCES runtimeforms ON UPDATE CASCADE
 );


 CREATE UNIQUE INDEX reports_links__rl_ident__uq ON report_links(rl_modulname, rl_ident) WHERE rl_ident IS NOT null;

 --
  CREATE OR REPLACE FUNCTION report_links__b_u() RETURNS TRIGGER AS $$
    BEGIN
     IF NOT (current_user='syncro') then
            new.rl_modified:=currenttime();
     END IF;
     RETURN new;
    END $$ LANGUAGE plpgsql;

   CREATE TRIGGER report_links__b_u
    BEFORE UPDATE
    ON report_links
    FOR EACH ROW
    EXECUTE PROCEDURE report_links__b_u();


-- [SYNCRO-TABLE] angehängte Reports
CREATE TABLE report_afterrep
 (rla_id                serial PRIMARY KEY,                                -- [SYNCRO:NotThisFields]
  rla_pos               integer,
  rla_stamp             timestamp(0)  UNIQUE DEFAULT currenttime(),
  rla_modified          timestamp(0),
  rla_r_stamp           timestamp(0) NOT NULL REFERENCES reports(r_stamp) ON UPDATE CASCADE ON DELETE CASCADE, -- hängt an diesem Report
  rla_r_dokutypes       varchar(250),                                      -- nur bei diesen Report-Typen (REFERENCES dokutypes)   http://redmine.prodat-sql.de/issues/6244
  rla_after_r_stamp     timestamp(0) NOT NULL REFERENCES reports(r_stamp) ON UPDATE CASCADE ON DELETE CASCADE, -- der angehangene Reports
  rla_connectdata       text,
  rla_autoprint         boolean DEFAULT FALSE
 );
 --

  CREATE OR REPLACE FUNCTION report_afterrep__b_u() RETURNS TRIGGER AS $$
    BEGIN
     IF NOT (current_user='syncro') then
            new.rla_modified:=currenttime();
     END IF;
     RETURN new;
    END $$ LANGUAGE plpgsql;

   CREATE TRIGGER report_afterrep__b_u
    BEFORE UPDATE
    ON report_afterrep
    FOR EACH ROW
    EXECUTE PROCEDURE report_afterrep__b_u();


  --modified des hauptreport setzen damit der sync auch mitläuft
  CREATE OR REPLACE FUNCTION report_afterrep__a_iud() RETURNS TRIGGER AS $$
    DECLARE id timestamp(0);
    BEGIN
     IF tg_op='DELETE' THEN
            id:=old.rla_r_stamp;
     ELSE
            id:=new.rla_r_stamp;
     END IF;
     --
     IF NOT (current_user='syncro') then
            UPDATE reports SET r_modified=now() WHERE r_stamp=id;
     END IF;
     --
     IF tg_op='DELETE' THEN
            RETURN old;
     ELSE
            RETURN new;
     END IF;
    END $$ LANGUAGE plpgsql;

   CREATE TRIGGER report_afterrep__a_iud
    AFTER INSERT OR UPDATE OR DELETE
    ON report_afterrep
    FOR EACH ROW
    EXECUTE PROCEDURE report_afterrep__a_iud();


CREATE TABLE report_afterdokument (
  rad_id                serial PRIMARY KEY,
  rad_pos               integer,                                        -- Druckposition
  rad_bez               varchar(100),
  -- rad_stamp             timestamp(0)  UNIQUE DEFAULT currenttime(),     -- Zeitstempel für Syncronisation
  -- rad_modified          timestamp(0),                                   -- Zeitstempel für Syncronisation
  rad_r_id              integer NOT NULL REFERENCES reports ON DELETE CASCADE,  -- hängt an diesem Report
  rad_r_dokutypes       varchar(250),                                           -- nur bei diesen Report-Typen (REFERENCES dokutypes)  http://redmine.prodat-sql.de/issues/6244
  rad_PDID_SQL          text,                                                   -- die Dokumente drucken, die beim Auswerten des Statements gefunden werden werden (ersts/einziges Feld: pd_id)
  rad_pd_tablename      varchar(30),                                            -- Tablename
  rad_r_kategorie       varchar(20),                                            -- Kategorie, in welcher gesucht wird (ArtikelNr, Adresse´...)
  rad_linkfield         varchar(30),                                            -- Value
  rad_autoprint         boolean DEFAULT FALSE,                                  -- übernommen aus AfterReports. Entscheidet (glaube ich) Vorschau oder Sofortdruck
  rad_enabled           boolean NOT NULL DEFAULT true,
  rad_txt               text                                                    -- Hinweise, Ergänzungen
 );


DROP FUNCTION IF EXISTS TSystem.reporting__attachements__report_afterdokument__defaults__create();

CREATE OR REPLACE FUNCTION TSystem.reporting__attachements__report_afterdokument__defaults__create(_suffix varchar = '') RETURNS VOID
  AS $$
  -- Erstellt default Anhangsdokumente. Löscht diese zuvor anhand id < 0
  DECLARE _r_id__zdok integer;
          _r_id__zabk integer;

          id integer;
  BEGIN

    _r_id__zdok := r_id FROM reports WHERE r_ident = 'TEMPLATE.ZDok'; --
    _r_id__zabk := r_id FROM reports WHERE r_ident = 'ZDok.ABK' || IFTHEN(_suffix <> '', '.' || _suffix, ''); -- ZDok.ABK."KUNDE" (ohne Quotes)

    IF _r_id__zdok IS null OR _r_id__zabk IS null THEN
      IF _suffix = '' THEN
        RAISE WARNING 'Reports not fount with SUFFIX: need TEMPLATE.ZDok, ZDok.ABK > %', _suffix;
        RETURN;
      ELSE
        RAISE EXCEPTION 'Reports not syned: need TEMPLATE.ZDok, ZDok.ABK';
      END IF;
    END IF;

    DROP TABLE IF EXISTS z_99_drop.report_afterdokument;
    CREATE TABLE z_99_drop.report_afterdokument AS SELECT * FROM report_afterdokument WHERE rad_id < 0;

    DELETE FROM report_afterdokument WHERE rad_id < 0 AND rad_r_id IN (_r_id__zdok, _r_id__zabk);

    -- Murx für Kundenreports
    IF _suffix = '' THEN
      id := 0;
    ELSE
      id := -1000;
    END IF;

    -- Anhangsdokument in Liste definieren
    INSERT INTO report_afterdokument
                (rad_id, rad_pos, rad_bez,                                rad_r_id, rad_r_dokutypes,                rad_pd_tablename, rad_r_kategorie,    rad_linkfield,          rad_pdid_sql)
         VALUES -- ZDok: Artikeldokumente (Default Zeichnung), Adressdokumente intern und extern
                ( id-10,      10, 'Artikeldokumente (Zeichnung)',      _r_id__zdok, 'ldsdok_bestdok;bestanf',       'art',            null,               'artikelnummer',        null)
               ,( id-11,      11, 'Artikeldokumente (Zeichnung)',      _r_id__zdok, 'awd',                          'art',            null,               'artikelnummer',        null) -- separat, damit man im Artikel auch für beide Zustände entweder Zeichnung oder Zeichnung auswärts angeben kann
               ,( id-20,      20, 'Adressdokumente  (Zieladresse)',    _r_id__zdok, 'ldsdok_bestdok;awd',           'adk',            null,               'adresse_adressant',    null)
               ,( id-21,      21, 'Adressdokumente  (Intern zB AGB)',  _r_id__zdok, 'ldsdok_bestdok;awd',           'adk',            null,               '"#"',                  null) -- zB AGB an Lieferanten
               ,( id-22,      22, 'QAB Dokumente',                     _r_id__zdok, 'ldsdok_bestdok;awd',           'qab',            'q_nr',             'p_q_nr',               null)
               ,( id-30,      30, 'Adressdokumente  (Intern zB AGB)',  _r_id__zdok, 'aufadok',                      'adk',            null,               '"#"',                  null) -- zB AGB an Kunden
                -- Standard-ABK
               ,( id-80,      10, 'Artikeldokumente (Zeichnungen)',    _r_id__zabk,  null,                          'art',            null,               'ld_aknr',              null)
               ,( id-200,     10, 'Materialzeugnisse',                 _r_id__zdok, 'lfs',                           null,            null,                null,                  'SELECT * FROM tdms.reporting__attachements__pd_id__chargenzeugnisse__beld_dokunr__get(:beld_dokunr)') -- eigentlich sollte das :dokument_nummer sein und aus dem WorkSQL und nicht aus der Oberfläche geholt werden, ist aber derzeit nur so funktionierend. Beim nächsten mal prüfen!
    ;

    DELETE FROM report_dokument_link WHERE rdl_id < 0 AND rdl_r_id IN (_r_id__zdok, _r_id__zabk);

    -- Ordner im DMS für Dokument aktivieren
    INSERT INTO report_dokument_link
                (rdl_id,       rdl_r_id, rdl_pd_id, rdl_pd_parentnodeident)
         VALUES -- Zeichnungsordner zum ZDok
                ( id-10,    _r_id__zdok,      null,                     15)
                -- Zeichungsordner zur StandardABK
               ,( id-80,    _r_id__zabk,      null,                     15)
    ;

    RETURN;

  END $$ LANGUAGE plpgsql;


-- SELECT TSystem.report_afterdokument__defaults__create();

--
CREATE TABLE report_dokument_link
 (
  rdl_id                  serial        PRIMARY KEY,
  rdl_rad_id              integer       NOT NULL REFERENCES report_afterdokument  ON DELETE CASCADE,                    -- Nach diesem Report ....
  rdl_pd_id               integer                REFERENCES picndoku              ON UPDATE CASCADE ON DELETE CASCADE,  -- ... das da drucken, wenn rad_PDID_SQL diese pd_id trifft. (spezifisches Dokument)
  rdl_pd_parentnodeident  varchar(20)                                                                                   -- ... das da drucken, wenn rad_PDID_SQL diese pd_parentnodeident trifft. (ganzen Ordner)
 );
--

--
CREATE OR REPLACE FUNCTION reportdokument_isprint(tablename varchar, pdid integer, node varchar) RETURNS boolean AS $$
  SELECT
    EXISTS(SELECT true FROM report_dokument_link WHERE rdl_rad_id = rad_id AND (
      -- Dokument direkt verlinkt (Listenausgabe festlegen > Dokument drucken)
      ($2 IS NOT NULL AND rdl_pd_id = $2)
      OR
      -- Verzeichnis direkt verlinkt (Listenausgabe festlegen > Verzeichnis drucken)
      ($3 IS NOT NULL AND rdl_pd_parentnodeident = $3)
      OR
      -- Dokument manuell in Verzeichnis verschoben (Drag&Drop)
      ($2 IS NOT NULL AND rdl_pd_parentnodeident = (SELECT pd_parentnodeident FROM picndoku WHERE pd_id = $2))
      OR
      -- Dokument via Dokumenttyp in Verzeichnis einsortiert
      ($2 IS NOT NULL AND rdl_pd_parentnodeident = (SELECT dt_parentnodeid FROM picndoku JOIN dokutypes ON dt_id = pd_doktype WHERE pd_id = $2))
    ))
  FROM reports
  JOIN report_afterdokument ON r_id=rad_r_id
  WHERE rad_pd_tablename = $1
    AND ($3 IS NULL OR rad_linkfield IS NOT NULL)
  ORDER BY 1 DESC
  LIMIT 1
 $$ LANGUAGE SQL STABLE;


-- [SYNCRO-TABLE] Übersetzungen von Report-Feldern
-- TODO : rt_r_stamp sollte besser rt_r_stamp sein
CREATE TABLE report_translations (
  rt_id           serial PRIMARY KEY,                                         -- [SYNCRO:NotThisFields]
  rt_r_id         integer     NOT NULL REFERENCES reports ON DELETE CASCADE,  -- [SYNCRO:SyncID=r_stamp+rt_varname+rt_spco] Report-ID
  rt_r_stamp      timestamp(0) REFERENCES reports (r_stamp) ON UPDATE CASCADE,
  rt_varname      varchar(80) NOT NULL,                                       -- [SYNCRO:SyncID=r_stamp+rt_varname+rt_spco] VariablenName
  rt_spco         SMALLINT    NOT NULL REFERENCES adkspco ON DELETE CASCADE,  -- [SYNCRO:SyncID=r_stamp+rt_varname+rt_spco] SprachCode
  rt_text         text,                                                       -- Übersetzung
  rt_kundtext     text                                                        -- [SYNCRO:NotThisFields] kundenspezifische Übersetzung
  -- System (tables__generate_missing_fields)
  -- modified_date timestamp(0)                                               -- [SYNCRO:Modified]
);
---
    CREATE FUNCTION report_translations__rt_r_stamp__b_iu() RETURNS TRIGGER
      AS $$
      BEGIN
        IF new.rt_r_stamp IS null THEN -- Anlage aus Delphi
           new.rt_r_stamp := r_stamp FROM reports WHERE r_id = new.rt_r_id;
        END IF;
        -- lokale id übersetzen
        new.rt_r_id := r_id FROM reports WHERE r_stamp = new.rt_r_stamp;
        RETURN new;
      END $$ LANGUAGE plpgsql;

    CREATE TRIGGER report_translations__rt_r_stamp__b_iu
     BEFORE INSERT OR UPDATE
     ON report_translations
     FOR EACH ROW
     EXECUTE PROCEDURE report_translations__rt_r_stamp__b_iu();

CREATE UNIQUE INDEX xtt17434 ON report_translations (rt_r_id, UPPER(rt_varname), rt_spco);

-- geplante Druckaufträge
CREATE TABLE report_print_queue (
  rpq_id                      serial PRIMARY KEY,
  rpq_table                   regclass,
  rpq_pkey                    varchar(80),
  rpq_owner_form              varchar(80) NOT NULL,             -- ModulForm für den Report
  rpq_modul_name              varchar(80) NOT NULL,             -- ModulForm.ClassName oder Alternatives
  rpq_r_pos                   varchar(80) NOT NULL DEFAULT '',  -- r_pos des gewünschten Reports, ansonsten wird bei AutoPrint der zuletzt Gedruckte verwendet
  rpq_auto_print              boolean,                          -- Automatisches Drucken > das Vorstatzformular automatisch schliessen - siehe Print-Params "???"
  rpq_no_after_rtf            boolean,                          -- r_afterRtf nicht ausführen
  rpq_params                  varchar(80)[],                    -- siehe Print-Params (Array: Name, Value, Name, Value, ...)
  rpq_no_print_preview        boolean,                          -- Keine Druckvorschau anzeigen, also sofort drucken
  rpq_show_printer_selection  boolean                           -- Druckerauswahl anzeigen
);

-- Systemsprache (wenn use_spco angegeben, dann nutze das, ansonsten die Systemsprache "curr_lang")
CREATE OR REPLACE FUNCTION report_system_spco(use_spco integer DEFAULT NULL) RETURNS integer AS $$
  --SELECT s_spco FROM adkspco WHERE s_spr_key = COALESCE(curr_lang(), 'D')
  SELECT IfThen($1 NOTNULL and $1 >= 0, $1, COALESCE((SELECT s_spco FROM adkspco WHERE s_spr_key = prodat_languages.curr_lang()), 0))::integer
 $$ LANGUAGE SQL;

CREATE OR REPLACE FUNCTION report_system_spkey() RETURNS varchar(5) AS $$
  SELECT s_spr_key FROM adkspco WHERE s_spco = report_system_spco()
 $$ LANGUAGE SQL;

-- speichert (INSERT OR UPDATE) die übergebene Übersetzung
CREATE OR REPLACE FUNCTION report_translation_set(new_r_id integer, new_varname varchar, new_spco integer, new_text text) RETURNS VOID AS $$
 DECLARE
  old_exists  boolean;
  old_varname varchar;
  old_text    text;
 BEGIN
  old_exists := NULL;
  SELECT true, rt_varname, rt_text INTO old_exists, old_varname, old_text FROM report_translations
  WHERE rt_r_id = new_r_id AND UPPER(rt_varname) = UPPER(new_varname) AND rt_spco = new_spco;
  IF old_exists IS NOT NULL THEN
    IF old_varname <> new_varname OR COALESCE(old_text, '') <> COALESCE(new_text, '') THEN
      UPDATE report_translations SET rt_varname = new_varname, rt_text = new_text
      WHERE rt_r_id = new_r_id AND UPPER(rt_varname) = UPPER(new_varname) AND rt_spco = new_spco;
    END IF;
  ELSE
    INSERT INTO report_translations (rt_r_id, rt_varname, rt_spco, rt_text)
    VALUES (new_r_id, new_varname, new_spco, new_text);
  END IF;
 END $$ LANGUAGE plpgsql;

-- geht alle Übersetzungssprachen des Reports durch und erstellt jeweils für jeden Variablennamen eine Übersetzung, wo es auch eine entsprechende DE-Übersetzung gibt
-- r_id kann NULL sein, für alle Reports
CREATE OR REPLACE FUNCTION report_translation_add_missing(r_id integer, r_spco integer) RETURNS boolean AS $$
  INSERT INTO report_translations (rt_r_id, rt_varname, rt_spco, rt_text)
  SELECT rt_r_id, rt_varname, $2, NULL FROM report_translations WHERE ($1 ISNULL OR rt_r_id = $1) AND rt_spco = 0
    AND NOT EXISTS(SELECT true FROM report_translations AS rt WHERE rt.rt_r_id = report_translations.rt_r_id AND UPPER(rt.rt_varname) = UPPER(report_translations.rt_varname) AND rt.rt_spco = $2);
  SELECT true;
 $$ LANGUAGE SQL;

-- gibt die gewünschten Übersetzungen zurück und wenn etwas fehlt, dann wenigstens die Deutsche
CREATE OR REPLACE FUNCTION report_translation_get_all(r_id integer, r_spco integer DEFAULT -1) RETURNS TABLE(rt_varname varchar, rt_text text, rt_spco SMALLINT) AS $$
  SELECT rt_varname, COALESCE(rt_kundtext, rt_text), rt_spco FROM report_translations
  WHERE (rt_r_id = $1 AND rt_spco = report_system_spco($2) AND COALESCE(rt_kundtext, rt_text, '') <> '')  -- lade aus Sprache
    OR (rt_r_id = $1 AND rt_spco = 0 AND NOT EXISTS(SELECT true FROM report_translations AS rt                              -- wenn nichts gefunden, dann lade aus DE
      WHERE rt.rt_r_id = $1 AND UPPER(rt.rt_varname) = UPPER(report_translations.rt_varname) AND rt.rt_spco = report_system_spco($2) AND COALESCE(rt.rt_kundtext, rt.rt_text, '') <> ''))
  $$ LANGUAGE SQL;
--

-- gibt für diese Variable die deutsche Übersezung zurück (oder NULL bei 'DE')
CREATE OR REPLACE FUNCTION report_translation_get_de(r_id integer, r_varname varchar, r_spco integer) RETURNS text AS $$
  SELECT rt_text FROM report_translations WHERE rt_r_id = $1 AND UPPER(rt_varname) = UPPER($2)
    AND rt_spco = 0 AND $3 <> 0
 $$ LANGUAGE SQL;

-- für DE:      TRUE, wenn für alle Sprachen diese Variable existiert
-- für Anderes: TRUE, wenn in DE (also im Report) etwas existiert
CREATE OR REPLACE FUNCTION report_translation_check(r_id integer, r_varname varchar, r_spco integer) RETURNS boolean AS $$
  SELECT
    CASE WHEN $3 = 0 THEN
      (SELECT COUNT(true) FROM report_translations WHERE rt_r_id = $1 AND UPPER(rt_varname) = UPPER($2) AND COALESCE(rt_text, '') <> '')
      =
      (SELECT COUNT(DISTINCT rt_spco) FROM report_translations WHERE rt_r_id = $1 AND COALESCE(rt_text, rt_kundtext, '') <> '') -- Anzahl der Sprachen
    ELSE
      (SELECT EXISTS(
         SELECT true FROM report_translations WHERE rt_r_id = $1 AND UPPER(rt_varname) = UPPER($2) AND rt_spco = $3 AND COALESCE(rt_text, '') <> ''
            AND EXISTS(SELECT true FROM report_translations WHERE rt_r_id = $1 AND UPPER(rt_varname) = UPPER($2) AND rt_spco = 0 AND COALESCE(rt_text, '') <> '')
      ))
    END
 $$ LANGUAGE SQL;

-- gibt TRUE zurück, wenn für diese Variable in einer der Sprachen ein Kunden-text angegeben wurde
CREATE OR REPLACE FUNCTION report_translation_kundcheck(r_id integer, r_varname varchar) RETURNS boolean AS $$
  SELECT EXISTS(
    SELECT true FROM report_translations WHERE rt_r_id = $1 AND UPPER(rt_varname) = UPPER($2) AND rt_kundtext NOTNULL
  )
 $$ LANGUAGE SQL;
